#version 100


//ZMAO SHADER V4 beta

/*
                           
                    ██████████████
                    ██████████████
                    ██████████████
                    ██████████████
                    █▒▒▒▒████▒▒▒▒█
                    ██████████████
                    ██████████████
                    ██████████████

*/

//Copyright © ZMAO
//ZMAO Source


uniform sampler2D TEXTURE_0;
uniform sampler2D TEXTURE_1;

varying vec2 uv;
varying vec4 color;
varying vec4 worldPosition;
varying vec4 fogColor;

void main()
{
	vec4 albedo = texture2D( TEXTURE_0, uv);

#ifdef ALPHA_TEST
	if (albedo.a < 0.1)
		discard;
#endif

	albedo.a *= color.a;

	vec2 occlusionUV = worldPosition.xz;
	vec4 occlusionTexture = texture2D( TEXTURE_1, occlusionUV);

	occlusionTexture.a *= 255.0;	// Alpha stores height of world

	// clamp the uvs
	vec2 uvclamp = clamp(occlusionUV, 0.0, 1.0);
	if (uvclamp.x == occlusionUV.x && uvclamp.y == occlusionUV.y && worldPosition.y < occlusionTexture.a) {
		albedo.a = 0.0;
	}

	float mixAmount = clamp ( (worldPosition.y - occlusionTexture.a)*9.0, 0.0, 1.0);
	vec3 lighting = mix(occlusionTexture.rgb, color.rgb, mixAmount);
	gl_FragColor = albedo *0.5;
	gl_FragColor.rgb *= lighting.rgb;

	//apply fog
	gl_FragColor.rgb = mix( gl_FragColor.rgb, fogColor.rgb, fogColor.a );

}


